<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Campaign extends Model 
{

    protected $table = 'campaign';
    public $timestamps = true;
    protected $fillable = array('node_id', 'name');

    public function node()
    {
        return $this->belongsTo('App\Models\Node');
    }

    public function campaignScheduledItems()
    {
        return $this->hasMany('App\Models\CampaignScheduledItem');
    }

    public function contentUpdateAudios()
    {
        return $this->hasMany('App\Models\ContentUpdate', 'audio_campaign_id');
    }

    public function contentUpdateVideos()
    {
        return $this->hasMany('App\Models\ContentUpdate', 'video_campaign_id');
    }

}